#ifndef EXPLOREMODEL_H
#define EXPLOREMODEL_H

#include "enums.h"
#include <QAbstractListModel>
#include <QUrl>
#include <QString>

typedef struct {
    Queries::QueryType type;
    QUrl feed;
    QString name;
} ExploreItem;

class ExploreModel : public QAbstractListModel
{
    Q_OBJECT

#if QT_VERSION >= 0x040700
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
#endif

public:
    enum Roles {
        NameRole = Qt::DisplayRole,
        TypeRole = Qt::UserRole + 1,
        FeedRole

    };

public:
    explicit ExploreModel(QObject *parent = 0);
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
#if QT_VERSION >= 0x040600
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
#endif

private:
    void addItem(Queries::QueryType type, const QUrl &feed, const QString &name);
    
signals:
    void countChanged(int count);
    
private:
    QList<ExploreItem> m_list;
};

#endif // EXPLOREMODEL_H
