#include "activityitem.h"
#include "utils.h"

ActivityItem::ActivityItem(QObject *parent) :
    QObject(parent),
    m_type(Activities::Track),
    m_typeString("track")
{
}

ActivityItem::ActivityItem(ActivityItem *activity, QObject *parent) :
    QObject(parent),
    m_id(activity->id()),
    m_type(activity->activityType()),
    m_typeString(activity->activityTypeString()),
    m_title(activity->title()),
    m_artist(activity->artist()),
    m_artistId(activity->artistId()),
    m_artistAvatarUrl(activity->artistAvatarUrl()),
    m_body(activity->body()),
    m_date(activity->date()),
    m_thumbnailUrl(activity->thumbnailUrl())
{
}

ActivityItem::ActivityItem(const QVariantMap &activity, QObject *parent) :
    QObject(parent),
    m_typeString(activity.value("type").toString()),
    m_date(Utils::localDateTimeFromString(activity.value("created_at").toString().section(' ', 0, 1)))
{
    if (this->activityTypeString() == "track") {
        this->loadTrack(activity);
    }
    else if (this->activityTypeString() == "playlist") {
        this->loadPlaylist(activity);
    }
    else if (this->activityTypeString() == "track-sharing") {
        this->loadTrackSharing(activity);
    }
    else if (this->activityTypeString() == "comment") {
        this->loadComment(activity);
    }
    else if (this->activityTypeString() == "favoriting") {
        this->loadFavourite(activity);
    }
    else {
        qWarning() << "ActivityItem::ActivityItem(): Unknown activity type.";
    }
}

void ActivityItem::loadTrack(const QVariantMap &track) {
    QVariantMap origin = track.value("origin").toMap();
    QVariantMap user = origin.value("user").toMap();
    this->setId(origin.value("id").toString());
    this->setTitle(origin.value("title").toString());
    this->setArtist(user.value("username").toString());
    this->setArtistId(user.value("id").toString());
    this->setArtistAvatarUrl(user.value("avatar_url").toString());
    this->setBody(origin.value("description").toString().remove('\r'));
    this->setThumbnailUrl(origin.value("artwork_url").toString());
    this->setActivityType(Activities::Track);
}

void ActivityItem::loadPlaylist(const QVariantMap &playlist) {
    QVariantMap origin = playlist.value("origin").toMap();
    QVariantMap user = origin.value("user").toMap();
    this->setId(origin.value("id").toString());
    this->setTitle(QString("%1 (%2)").arg(origin.value("title").toString()).arg(tr("set")));
    this->setArtist(user.value("username").toString());
    this->setArtistId(user.value("id").toString());
    this->setArtistAvatarUrl(user.value("avatar_url").toString());
    this->setBody(origin.value("description").toString().remove('\r'));
    this->setThumbnailUrl(origin.value("artwork_url").toString());
    this->setActivityType(Activities::Playlist);
}

void ActivityItem::loadTrackSharing(const QVariantMap &track) {
    QVariantMap origin = track.value("origin").toMap().value("track").toMap();
    QVariantMap user = origin.value("user").toMap();
    this->setId(origin.value("id").toString());
    this->setTitle(origin.value("title").toString());
    this->setArtist(user.value("username").toString());
    this->setArtistId(user.value("id").toString());
    this->setArtistAvatarUrl(user.value("avatar_url").toString());
    this->setBody(origin.value("description").toString().remove('\r'));
    this->setThumbnailUrl(origin.value("artwork_url").toString());
    this->setActivityType(Activities::TrackSharing);
}

void ActivityItem::loadComment(const QVariantMap &comment) {
    QVariantMap origin = comment.value("origin").toMap();
    QVariantMap track = origin.value("track").toMap();
    QVariantMap user = origin.value("user").toMap();
    this->setId(track.value("id").toString());
    this->setTitle(track.value("title").toString());
    this->setArtist(user.value("username").toString());
    this->setArtistId(user.value("id").toString());
    this->setArtistAvatarUrl(user.value("avatar_url").toString());
    this->setBody(origin.value("body").toString().remove('\r'));
    this->setThumbnailUrl(track.value("artwork_url").toString());
    this->setActivityType(Activities::Comment);
}

void ActivityItem::loadFavourite(const QVariantMap &favourite) {
    QVariantMap origin = favourite.value("origin").toMap();
    QVariantMap track = origin.value("track").toMap();
    QVariantMap user = origin.value("user").toMap();
    this->setId(track.value("id").toString());
    this->setTitle(track.value("title").toString());
    this->setArtist(user.value("username").toString());
    this->setArtistId(user.value("id").toString());
    this->setArtistAvatarUrl(user.value("avatar_url").toString());
    this->setBody(QString("%1 %2").arg(tr("Favourited by")).arg(this->artist()));
    this->setThumbnailUrl(track.value("artwork_url").toString());
    this->setActivityType(Activities::Favouriting);
}

void ActivityItem::loadActivity(ActivityItem *activity) {
    this->setId(activity->id());
    this->setActivityType(activity->activityType());
    this->setActivityTypeString(activity->activityTypeString());
    this->setTitle(activity->title());
    this->setArtist(activity->artist());
    this->setArtistId(activity->artistId());
    this->setArtistAvatarUrl(activity->artistAvatarUrl());
    this->setBody(activity->body());
    this->setDate(activity->date());
    this->setThumbnailUrl(activity->thumbnailUrl());
}
