#ifndef SOUNDCLOUD_H
#define SOUNDCLOUD_H

#include <QObject>

class QNetworkAccessManager;
class QNetworkReply;
class QUrl;

class SoundCloud : public QObject
{
    Q_OBJECT

public:
    explicit SoundCloud(QObject *parent = 0);
    ~SoundCloud();
    inline QNetworkAccessManager* networkAccessManager() const { return m_nam; }
    inline void setNetworkAccessManager(QNetworkAccessManager *manager) { m_nam = manager; }
    inline QString username() const { return m_username; }
    inline QString accessToken() const { return m_accessToken; }
    inline bool userSignedIn() const { return !this->accessToken().isEmpty(); }
    QNetworkReply* createReply(QUrl url, int offset = 0);
    QNetworkReply* createSearchReply(int queryType, const QString &query, int order, int offset = 0);
    QUrl getStreamUrl(QUrl url);
    QUrl getDownloadUrl(QUrl url);

    static SoundCloud* instance();

public slots:
    void setCredentials(const QString &user, const QString &token);
    void setAccessToken(const QString &token);
    void setUsername(const QString &user);

signals:
    void accessTokenChanged();
    void usernameChanged();
    void userSignedInChanged(bool signedIn);

private:
    QNetworkAccessManager *m_nam;
    QString m_username;
    QString m_accessToken;
};

#endif // SOUNDCLOUD_H
