#ifndef TRACKSELECTIONWINDOW_H
#define TRACKSELECTIONWINDOW_H

#include "../base/enums.h"
#include <QWidget>
#include <QVariantMap>

class QAbstractItemModel;
class ListView;
class QMaemo5EditBar;
class QPushButton;
class QVBoxLayout;
class QModelIndex;

class TrackSelectionWindow : public QWidget
{
    Q_OBJECT
public:
    explicit TrackSelectionWindow(QAbstractItemModel *model, const QString &text, const char* slot, QWidget *parent);
    ~TrackSelectionWindow();
    void positionAtIndex(const QModelIndex &index);

private:
    inline bool hasNowPlayingButton() const { return false; }

private slots:
    void onItemClicked(const QModelIndex &index);
    void onButtonClicked();
    void addTracksToFavourites();
    void deleteTracksFromFavourites();
    void addTrackDownloads();
    void queueTracks();
    void deleteTracks();

signals:
    void accepted();

private:
    QAbstractItemModel *m_model;
    ListView *m_listView;
    QMaemo5EditBar *m_editBar;
    QPushButton *m_acceptButton;
    QVBoxLayout *m_vbox;
};

#endif // TRACKSELECTIONWINDOW_H
