#ifndef THUMBNAILLABEL_H
#define THUMBNAILLABEL_H

#include <QWidget>

class QImage;
class QMouseEvent;
class QPaintEvent;

class ThumbnailLabel : public QWidget
{
    Q_OBJECT

public:
    explicit ThumbnailLabel(QWidget *parent = 0);
    inline bool interactive() const { return m_interactive; }
    inline void setInteractive(bool interactive) { m_interactive = interactive; }
    inline QImage image() const { return m_image; }
    void setImage(const QImage &image);

protected:
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    void leaveEvent(QEvent *event);
    void paintEvent(QPaintEvent *event);

signals:
    void clicked();

protected:
    QImage m_image;
    bool m_interactive;
    bool m_pressed;
};

#endif // THUMBNAILLABEL_H
