#ifndef STACKEDWINDOW_H
#define STACKEDWINDOW_H

#include "../base/enums.h"
#include <QMainWindow>

class NowPlayingButton;

class StackedWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit StackedWindow(QWidget *parent = 0);
    ~StackedWindow();
    inline virtual bool inPortrait() const { return m_portrait; }
    inline virtual bool hasNowPlayingButton() const { return true; }

protected:
    void showEvent(QShowEvent *event);
    void closeEvent(QCloseEvent *event);
    inline virtual void setLandscapeLayout() {}
    inline virtual void setPortraitLayout() {}

protected slots:
    void setOrientation(ScreenOrientation::Orientation orientation);
    void onOrientationChanged();
    void toggleBusy(bool busy);

protected:
    bool m_portrait;
};

#endif // STACKEDWINDOW_H
