#ifndef COMMENTDIALOG_H
#define COMMENTDIALOG_H

#include "abstractdialog.h"
#include "../base/trackitem.h"

class QTextEdit;
class QPushButton;
class QDialogButtonBox;
class QGridLayout;
class QScrollArea;
class QCheckBox;

class CommentDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit CommentDialog(QSharedPointer<TrackItem> track, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onCommentTextChanged();
    void submitComment();

private:
    QSharedPointer<TrackItem> m_track;
    qint64 m_timestamp;
    QTextEdit *m_commentEdit;
    QCheckBox *m_timestampCheckbox;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // COMMENTDIALOG_H
