#ifndef ARCHIVETRACKSTAB_H
#define ARCHIVETRACKSTAB_H

#include "abstracttab.h"

class ArchiveTrackModel;
class FilterBox;
class ListView;
class QVBoxLayout;
class QMenu;
class QModelIndex;
class QAction;
class QLabel;

class ArchiveTracksTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit ArchiveTracksTab(QWidget *parent = 0);

protected:
    void keyPressEvent(QKeyEvent *event);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onItemClicked(const QModelIndex &index);
    void showContextMenu(const QPoint &pos);
    void playTrack(const QModelIndex &index);
    void queueTrack();
    void showConfirmDeleteDialog();
    void deleteTrack();
    void queueTracks();
    void deleteTracks();
    void showFilterBox();
    void onCountChanged(int count);
    
private:
    ArchiveTrackModel *m_model;
    ListView *m_view;
    FilterBox *m_filterBox;
    QAction *m_queueAction;
    QAction *m_deleteAction;
    QMenu *m_contextMenu;
    QAction *m_contextQueueAction;
    QAction *m_contextDeleteAction;
    QLabel *m_noResultsLabel;
    QVBoxLayout *m_vbox;
};

#endif // ARCHIVETRACKSTAB_H
