#ifndef ARCHIVEPLAYLISTTRACKSWINDOW_H
#define ARCHIVEPLAYLISTTRACKSWINDOW_H

#include "stackedwindow.h"
#include "../base/playlistitem.h"
#include "../base/trackitem.h"

class ArchiveTrackModel;
class ListView;
class ThumbnailLabel;
class SeparatorLabel;
class ScrollArea;
class QAction;
class QLabel;
class QPushButton;
class QModelIndex;

class ArchivePlaylistTracksWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit ArchivePlaylistTracksWindow(QSharedPointer<PlaylistItem> playlist, QWidget *parent);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void queueTracks();
    void showContextMenu(const QPoint &pos);
    void queueTrack();
    void onItemClicked(const QModelIndex &index);
    void showTrackInfo(QSharedPointer<TrackItem> track);
    void playTrack(const QModelIndex &index);
    void playPlaylist();
    void setThumbnail();

private:
    QSharedPointer<PlaylistItem> m_playlist;
    ListView *m_listView;
    ArchiveTrackModel *m_model;
    QAction *m_addToQueueAction;
    QMenu *m_contextMenu;
    QAction *m_addToQueueContextAction;
    QLabel *m_titleLabel;
    QLabel *m_descriptionLabel;
    QLabel *m_artistLabel;
    QLabel *m_dateLabel;
    ThumbnailLabel *m_thumbnail;
    QPushButton *m_playButton;
    SeparatorLabel *m_separator1;
    SeparatorLabel *m_separator2;
    ScrollArea *m_scrollArea;
};

#endif // ARCHIVEPLAYLISTTRACKSWINDOW_H
