#ifndef ARCHIVEPLAYLISTSTAB_H
#define ARCHIVEPLAYLISTSTAB_H

#include "abstracttab.h"

class ArchivePlaylistModel;
class FilterBox;
class ListView;
class QVBoxLayout;
class QMenu;
class QModelIndex;
class QAction;
class QLabel;

class ArchivePlaylistsTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit ArchivePlaylistsTab(QWidget *parent = 0);

protected:
    void keyPressEvent(QKeyEvent *event);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onItemClicked(const QModelIndex &index);
    void showContextMenu(const QPoint &pos);
    void showConfirmDeleteDialog();
    void deletePlaylist();
    void showFilterBox();
    void onCountChanged(int count);

private:
    ArchivePlaylistModel *m_model;
    ListView *m_view;
    FilterBox *m_filterBox;
    QMenu *m_contextMenu;
    QAction *m_contextDeleteAction;
    QLabel *m_noResultsLabel;
    QVBoxLayout *m_vbox;
};

#endif // ARCHIVEPLAYLISTSTAB_H
