#include "activitylistdelegate.h"
#include "../base/activitylistmodel.h"
#include <QPainter>
#include <QMaemo5Style>
#include <QMouseEvent>

ActivityListDelegate::ActivityListDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void ActivityListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    if (((option.state) & (QStyle::State_Selected)) && (!index.data(ActivityListModel::ThumbnailPressedRole).toBool()) && (!index.data(ActivityListModel::ArtistAvatarPressedRole).toBool())) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect iconRect = option.rect;
    iconRect.moveTopLeft(QPoint(iconRect.left() + 8, iconRect.top() + 8));
    iconRect.setSize(QSize(48, 48));

    QImage avatar = index.data(ActivityListModel::ArtistAvatarRole).value<QImage>();

    if (avatar.isNull()) {
        avatar = QImage("/usr/share/icons/hicolor/48x48/hildon/general_default_avatar.png");
    }

    if (index.data(ActivityListModel::ArtistAvatarPressedRole).toBool()) {
        painter->setOpacity(0.5);
    }

    painter->drawImage(iconRect, avatar);
    painter->setOpacity(1);

    QRect textRect = option.rect;
    textRect.setTopLeft(QPoint(iconRect.right() + 8, iconRect.top()));

    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::AlignTop, index.data(ActivityListModel::TitleRole).toString());

    textRect.setTop(textRect.top() + 32);
    textRect.setHeight(78);

    QFont font;
    font.setPixelSize(20);

    painter->setFont(font);
    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::AlignTop | Qt::TextWordWrap, index.data(ActivityListModel::BodyRole).toString());
    painter->setClipping(false);

    iconRect.moveTopLeft(QPoint(textRect.left(), textRect.bottom() + 8));
    iconRect.setSize(QSize(96, 96));

    QImage thumbnail = index.data(ActivityListModel::ThumbnailRole).value<QImage>();

    if (thumbnail.isNull()) {
        thumbnail = QImage("/usr/share/icons/hicolor/124x124/hildon/mediaplayer_default_album.png").scaled(96, 96, Qt::KeepAspectRatio, Qt::SmoothTransformation);
    }

    if (index.data(ActivityListModel::ThumbnailPressedRole).toBool()) {
        painter->setOpacity(0.5);
    }

    painter->drawImage(iconRect, thumbnail);
    painter->setOpacity(1);

    textRect.setTop(iconRect.bottom() + 8);
    textRect.setHeight(32);

    painter->setClipRect(textRect);
    painter->setPen(QMaemo5Style::standardColor("SecondaryTextColor"));
    painter->drawText(textRect, Qt::AlignBottom, QString("%1 - %2").arg(index.data(ActivityListModel::DateRole).toString()).arg(index.data(ActivityListModel::ArtistRole).toString()));
    painter->restore();
}

bool ActivityListDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index) {
    if (event->type() == QEvent::MouseButtonPress) {
        QMouseEvent *mouse = static_cast<QMouseEvent*>(event);

        QRect iconRect = option.rect;
        iconRect.setSize(QSize(48, 48));
        iconRect.moveTopLeft(QPoint(iconRect.left() + 8, iconRect.top() + 8));

        if (iconRect.contains(mouse->pos())) {
            return model->setData(index, index.row(), ActivityListModel::ArtistAvatarPressedRole);
        }
        else {
            iconRect.moveTopLeft(QPoint(iconRect.right() + 8, iconRect.top() + 84));
            iconRect.setSize(QSize(96, 96));

            if (iconRect.contains(mouse->pos())) {
                return model->setData(index, index.row(), ActivityListModel::ThumbnailPressedRole);
            }
        }

        return true;
    }

    if (event->type() == QEvent::MouseButtonRelease) {
        QMouseEvent *mouse = static_cast<QMouseEvent*>(event);

        if (index.data(ActivityListModel::ArtistAvatarPressedRole).toBool()) {
            QRect avatarRect = option.rect;
            avatarRect.setSize(QSize(48, 48));
            avatarRect.moveTopLeft(QPoint(avatarRect.left() + 8, avatarRect.top() + 8));

            if (avatarRect.contains(mouse->pos())) {
                emit showUserChannel(index);
            }

            return model->setData(index, -1, ActivityListModel::ArtistAvatarPressedRole);
        }
        else if (index.data(ActivityListModel::ThumbnailPressedRole).toBool()) {
            QRect thumbnailRect = option.rect;
            thumbnailRect.moveTopLeft(QPoint(thumbnailRect.left() + 62, thumbnailRect.top() + 92));
            thumbnailRect.setSize(QSize(96, 96));

            if (thumbnailRect.contains(mouse->pos())) {
                emit play(index);
            }

            return model->setData(index, -1, ActivityListModel::ThumbnailPressedRole);
        }
        else if (option.rect.contains(mouse->pos())) {
            emit clicked(index);
            return true;
        }
    }

    return false;
}

QSize ActivityListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 272);
}
