#ifndef SELECTIONMODELS_H
#define SELECTIONMODELS_H

#include "enums.h"
#include <QStandardItemModel>

class SelectionModel : public QStandardItemModel
{
    Q_OBJECT

public:
    explicit SelectionModel(QObject *parent = 0);
    void addItem(const QString &name, const QVariant &value);
    Q_INVOKABLE QString name(int row) const;
    Q_INVOKABLE QVariant value(int row) const;
    Q_INVOKABLE QVariantMap get(int row) const;
    Q_INVOKABLE inline Qt::Alignment textAlignment() const { return m_textAlignment; }
    Q_INVOKABLE inline void setTextAlignment(Qt::Alignment alignment) { m_textAlignment = alignment; }

private:
    Qt::Alignment m_textAlignment;
};

class SearchOrderModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit SearchOrderModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class SearchTypeModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit SearchTypeModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class ScreenOrientationModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit ScreenOrientationModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class LanguageModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit LanguageModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class ThemeModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit ThemeModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class ActiveColorModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit ActiveColorModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

#ifdef MEDIA_PLAYERS_ENABLED
class MediaPlayerModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit MediaPlayerModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};
#endif

class TransferPriorityModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit TransferPriorityModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class ConcurrentTransfersModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit ConcurrentTransfersModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class NetworkProxyTypeModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit NetworkProxyTypeModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

class DownloadFormatModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit DownloadFormatModel(QObject *parent = 0);

signals:
    void countChanged(int count);
};

#endif // SELECTIONMODELS_H
