#ifndef COMMENTLISTMODEL_H
#define COMMENTLISTMODEL_H

#include "commentitem.h"
#include <QSharedPointer>
#include <QAbstractListModel>

#ifndef QML_USER_INTERFACE
class ThumbnailCache;
#endif

class CommentListModel : public QAbstractListModel
{
    Q_OBJECT
    
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)
    Q_PROPERTY(QUrl feed
               READ feed
               WRITE setFeed)
    Q_PROPERTY(QString trackId
               READ trackId
               WRITE setTrackId)

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        BodyRole,
        ArtistRole,
        ArtistIdRole,
        ArtistAvatarUrlRole,
        DateRole,
        TrackIdRole
#ifndef QML_USER_INTERFACE
        ,ArtistAvatarRole,
        AvatarPressedRole
#endif
    };
    
public:
    explicit CommentListModel(QObject *parent = 0);
    ~CommentListModel();
    inline QString trackId() const { return m_trackId; }
    void setTrackId(const QString &id = QString());
    inline QUrl feed() const { return m_feed; }
    inline void setFeed(const QUrl &feed) { m_feed = feed; }
    inline bool loading() const { return m_loading; }
    inline bool moreResults() const { return m_moreResults; }
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
#ifndef QML_USER_INTERFACE
    bool setData(const QModelIndex &index, const QVariant &value, int role);
#endif
    QSharedPointer<CommentItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE CommentItem* getFromQML(int row) const;
#endif
    
public slots:
    void clear();
    void reset();
    void getComments(const QString &id = QString());
    void getMoreComments();
    void appendComment(QSharedPointer<CommentItem> comment);
    void insertComment(int row, QSharedPointer<CommentItem> comment);
    bool removeComment(const QVariant &value, int role = IdRole);

private:
    inline void setLoading(bool loading) { m_loading = loading; emit loadingChanged(loading); }
    inline void setMoreResults(bool more) { m_moreResults = more; }
    inline int offset() const { return m_offset; }
    inline void setOffset(int offset) { m_offset = offset; }
    inline bool error() const { return m_error; }
    inline void setError(bool error) { m_error = error; }
    bool removeRow(int row, const QModelIndex &parent = QModelIndex());
    
private slots:
    void addComments();
    inline void onError() { setError(true); setLoading(false); }
    inline void stopLoading() { this->setLoading(false); emit countChanged(this->rowCount()); }
    void onCommentAdded(QSharedPointer<CommentItem> comment);
#ifndef QML_USER_INTERFACE
    void onThumbnailReady();
#endif
        
signals:
    void loadingChanged(bool loading);
    void countChanged(int count);
    
private:
#ifndef QML_USER_INTERFACE
    ThumbnailCache *m_cache;
    int m_avatarPressedRow;
#endif
    QString m_trackId;
    QUrl m_feed;
    bool m_loading;
    bool m_moreResults;
    bool m_error;
    int m_offset;
    QList< QSharedPointer<CommentItem> > m_list;
};

#endif // COMMENTLISTMODEL_H
