#ifndef CLIPBOARDMONITOR_H
#define CLIPBOARDMONITOR_H

#include <QObject>
#include <qplatformdefs.h>

#ifdef MEEGO_EDITION_HARMATTAN
class QTimer;
#endif

class ClipboardMonitor : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString clipboardUrl
               READ clipboardUrl
               NOTIFY clipboardUrlChanged)

public:
    explicit ClipboardMonitor(QObject *parent = 0);
    inline QString clipboardUrl() const { return m_clipboardUrl; }

    static ClipboardMonitor* instance();

private:
    void setClipboardUrl(const QString &url);
    
private slots:
    void onClipboardTextChanged();

signals:
    void clipboardUrlChanged(const QString &url);
#ifndef SYMBIAN_OS
    void gotClipboardUrl(const QString &url);
#endif

private:
    static ClipboardMonitor* m_instance;
    QString m_clipboardUrl;
#ifdef MEEGO_EDITION_HARMATTAN
    QTimer *m_timer;
#endif
};

#endif // CLIPBOARDMONITOR_H
