#include "waveformlabel.h"
#include "../base/mediaplayer.h"
#include <QPaintEvent>
#include <QPainter>
#include <QMaemo5Style>
#include <QShowEvent>
#include <QHideEvent>
#include <QMouseEvent>

WaveformLabel::WaveformLabel(QWidget *parent) :
    ThumbnailLabel(parent)
{
}

void WaveformLabel::showEvent(QShowEvent *event) {
    this->connect(MediaPlayer::instance(), SIGNAL(positionChanged(qint64)), this, SLOT(update()));
    event->accept();
}

void WaveformLabel::hideEvent(QHideEvent *event) {
    this->disconnect(MediaPlayer::instance(), SIGNAL(positionChanged(qint64)), this, SLOT(update()));
    event->accept();
}

void WaveformLabel::mousePressEvent(QMouseEvent *event) {
    m_pressed = true;
    event->accept();
}

void WaveformLabel::mouseReleaseEvent(QMouseEvent *event) {
    if (this->rect().contains(event->pos())) {
        m_pressed = false;
        event->accept();
        MediaPlayer::instance()->setPosition(float (event->x()) / this->width() * MediaPlayer::instance()->duration());
        emit clicked();
    }
    else {
        event->ignore();
    }
}

void WaveformLabel::leaveEvent(QEvent *event) {
    m_pressed = false;
    event->accept();
}

void WaveformLabel::paintEvent(QPaintEvent *event) {
    QPainter painter(this);

    if (!this->image().isNull()) {
        painter.drawImage(this->rect(), this->image());
    }

    painter.setOpacity(1);
    painter.setPen(QMaemo5Style::standardColor("ActiveTextColor"));
    int x = float (MediaPlayer::instance()->position()) / MediaPlayer::instance()->duration() * this->width();
    painter.drawLine(x, 0, x, this->height());

    event->accept();
}
