#ifndef USERLISTWINDOW_H
#define USERLISTWINDOW_H

#include "stackedwindow.h"

class UserListModel;
class ListView;
class QLabel;
class QModelIndex;

class UserListWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit UserListWindow(QWidget *parent);
    void setUserFeed(const QUrl &feed);
    void search(const QString &query);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);

private:
    UserListModel *m_model;
    ListView *m_listView;
    QLabel *m_noResultsLabel;
};

#endif // USERLISTWINDOW_H
