#ifndef NOWPLAYINGMEDIATAB_H
#define NOWPLAYINGMEDIATAB_H

#include "abstracttab.h"
#include "../base/trackitem.h"

class ThumbnailLabel;
class QListView;
class QMenu;
class QAction;
class QSlider;
class QLabel;
class MediaPlayerButton;
class QModelIndex;

class NowPlayingMediaTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit NowPlayingMediaTab(QWidget *parent = 0);

protected:
    void showEvent(QShowEvent *event);
    void hideEvent(QHideEvent *event);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setThumbnail();
    void onThumbnailClicked();
    void onSliderReleased();
    void onPositionChanged(qint64 position);
    void onDurationChanged(qint64 duration);
    void onCountChanged(int count);
    void onCurrentIndexChanged(int index);
    void onCurrentTrackChanged(QSharedPointer<TrackItem> track);
    void onItemClicked(const QModelIndex &index);
    void showContextMenu(const QPoint &pos);
    void deleteTrackFromQueue();
    
private:
    ThumbnailLabel *m_thumbnailLabel;
    QListView *m_view;
    QSlider *m_progressSlider;
    QLabel *m_trackNumberLabel;
    QLabel *m_titleLabel;
    QLabel *m_artistLabel;
    QLabel *m_positionLabel;
    QLabel *m_durationLabel;
    QMenu *m_contextMenu;
    QAction *m_deleteAction;
    QAction *m_clearAction;
    QWidget *m_toolBar;
    QWidget *m_container;
    MediaPlayerButton *m_playPauseButton;
    MediaPlayerButton *m_previousButton;
    MediaPlayerButton *m_nextButton;
    MediaPlayerButton *m_repeatButton;
};

#endif // NOWPLAYINGMEDIATAB_H
