#ifndef GROUPLISTTAB_H
#define GROUPLISTTAB_H

#include "abstracttab.h"
#include "../base/groupitem.h"

class ListView;
class GroupListModel;
class QLabel;
class QGridLayout;
class QModelIndex;

class GroupListTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit GroupListTab(QWidget *parent = 0);
    void setGroupFeed(const QUrl &feed);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showGroup(QSharedPointer<GroupItem> group);

private:
    ListView *m_listView;
    GroupListModel *m_model;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // GROUPLISTTAB_H
