#include "userlistwindow.h"
#include "channelwindow.h"
#include "userlistdelegate.h"
#include "../base/userlistmodel.h"
#include "listview.h"
#include <QLabel>
#include <QMaemo5Style>

UserListWindow::UserListWindow(QWidget *parent) :
    StackedWindow(parent),
    m_model(new UserListModel(this)),
    m_listView(new ListView(this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No people found")), this))
{
    this->setCentralWidget(m_listView);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new UserListDelegate(m_listView));
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMoreUsers()));

    this->onOrientationChanged();
}

void UserListWindow::setUserFeed(const QUrl &feed) {
    m_model->getUsers(feed);
}

void UserListWindow::search(const QString &query) {
    this->setWindowTitle(tr("Search") + QString(" ('%1')").arg(query));
    m_model->search(query);
}

void UserListWindow::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void UserListWindow::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void UserListWindow::onLoadingChanged(bool loading) {
    this->toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void UserListWindow::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void UserListWindow::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showUserChannel(index.data(UserListModel::IdRole).toString());
    }
}

void UserListWindow::showUserChannel(const QString &userId) {
    ChannelWindow *window = new ChannelWindow(userId, this);
    window->show();
}
