#include "userlisttab.h"
#include "userlistdelegate.h"
#include "tracklistwindow.h"
#include "channelwindow.h"
#include "../base/userlistmodel.h"
#include "../base/notifications.h"
#include "../base/windowstack.h"
#include "listview.h"
#include <QLabel>
#include <QGridLayout>
#include <QAction>
#include <QMaemo5Style>

UserListTab::UserListTab(const QString &userId, QWidget *parent) :
    AbstractTab(parent),
    m_userId(userId),
    m_model(new UserListModel(this)),
    m_listView(new ListView(this)),
    m_tracksAction(new QAction(tr("Latest tracks"), this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No followings found")), this)),
    m_grid(new QGridLayout(this))
{
    this->addAction(m_tracksAction);

    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new UserListDelegate(m_listView));
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMoreUsers()));
    this->connect(m_tracksAction, SIGNAL(triggered()), this, SLOT(showFollowingTracks()));

    this->onOrientationChanged();
}

void UserListTab::setUserFeed(const QUrl &feed) {
    m_model->getUsers(feed);
}

void UserListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void UserListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void UserListTab::onLoadingChanged(bool loading) {
    Notifications::toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void UserListTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void UserListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showUserChannel(index.data(UserListModel::IdRole).toString());
    }
}

void UserListTab::showUserChannel(const QString &userId) {
    ChannelWindow *window = new ChannelWindow(userId, WindowStack::instance()->currentWindow());
    window->show();
}

void UserListTab::showFollowingTracks() {
    TrackListWindow *window = new TrackListWindow(WindowStack::instance()->currentWindow());
    window->setTrackFeed(QString("http://api.soundcloud.com/users/%1/followings?limit=30").arg(m_userId));
}
