#ifndef TRANSFERDETAILSDIALOG_H
#define TRANSFERDETAILSDIALOG_H

#include "abstractdialog.h"
#include "../base/transferitem.h"

class TransferPrioritySelector;
class QLabel;
class QGridLayout;
class QCheckBox;

class TransferDetailsDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit TransferDetailsDialog(QSharedPointer<TransferItem> transfer, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onTransferStatusChanged(Transfers::TransferStatus status);
    void onTransferStatusInfoChanged(const QString &info);
    void onTransferSizeChanged(qint64 size);
    void onTransferCurrentIndexChanged(int index);
    void onTransferProgressChanged(int progress);
    void onTransferSpeedChanged(int speed);
    void onPauseResumeClicked();
    void cancelTransfer();

private:
    QSharedPointer<TransferItem> m_transfer;
    QLabel *m_titleHeader;
    QLabel *m_statusHeader;
    QLabel *m_sizeHeader;
    QLabel *m_progressHeader;
    QLabel *m_titleLabel;
    QLabel *m_statusLabel;
    QLabel *m_statusIcon;
    QLabel *m_infoLabel;
    QLabel *m_sizeLabel;
    QLabel *m_progressLabel;
    QLabel *m_speedLabel;
    TransferPrioritySelector *m_prioritySelector;
    QPushButton *m_pauseResumeButton;
    QPushButton *m_cancelButton;
    QGridLayout *m_grid;
};

#endif // TRANSFERDETAILSDIALOG_H
