#ifndef SOUNDCLOUDWEBVIEW_H
#define SOUNDCLOUDWEBVIEW_H

#include "abstractdialog.h"

class WebView;
class QProgressBar;
class QUrl;

class SoundCloudWebView : public AbstractDialog
{
    Q_OBJECT

public:
    explicit SoundCloudWebView(QWidget *parent = 0);

protected:
    void showEvent(QShowEvent *event);
    void hideEvent(QHideEvent *event);

private:
    inline void setLandscapeLayout() { this->setFixedHeight(340); }
    inline void setPortraitLayout() { this->setFixedHeight(600); }

private slots:
    void onUrlChanged(const QUrl &url);
    
private:
    WebView *m_view;
    QProgressBar *m_progressBar;
};

#endif // SOUNDCLOUDWEBVIEW_H
