#ifndef SHARINGDIALOG_H
#define SHARINGDIALOG_H

#include "abstractdialog.h"
#include "../base/enums.h"
#include "../base/trackitem.h"

class QGridLayout;
class QDialogButtonBox;
class QPlainTextEdit;
class QMaemo5ValueButton;
class ConnectionsDialog;

class SharingDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit SharingDialog(QSharedPointer<TrackItem> track, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onMessageChanged();
    void onConnectionNamesChanged(const QStringList &names);
    void showConnectionsDialog();
    void shareTrack();

private:
    QSharedPointer<TrackItem> m_track;
    QPlainTextEdit *m_messageEdit;
    QMaemo5ValueButton *m_connectionsSelector;
    ConnectionsDialog *m_connectionsDialog;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_button;
    QGridLayout *m_grid;
};

#endif // SHARINGDIALOG_H
