#ifndef PLAYLISTVIDEOSWINDOW_H
#define PLAYLISTVIDEOSWINDOW_H

#include "stackedwindow.h"
#include "../base/playlistitem.h"
#include "../base/trackitem.h"

class TrackListModel;
class ListView;
class ThumbnailLabel;
class SeparatorLabel;
class QAction;
class QLabel;
class QScrollArea;
class QPushButton;
class QModelIndex;

class PlaylistTracksWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit PlaylistTracksWindow(QSharedPointer<PlaylistItem> playlist, QWidget *parent);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setMenuActions();
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void addTracksToFavourites();
    void addTrackDownloads();
    void queueTracks();
    void showContextMenu(const QPoint &pos);
    void addTrackToFavourites();
    void addTrackDownload();
    void addPlaylistDownload();
    void queueTrack();
    void onItemClicked(const QModelIndex &index);
    void showTrackInfo(QSharedPointer<TrackItem> track);
    void playTrack(const QModelIndex &index);
    void playPlaylist();
    void showUserChannel();
    void setThumbnail();

private:
    QSharedPointer<PlaylistItem> m_playlist;
    ListView *m_listView;
    TrackListModel *m_model;
    QAction *m_addToFavouritesAction;
    QAction *m_addToQueueAction;
    QAction *m_downloadTracksAction;
    QAction *m_downloadPlaylistAction;
    QMenu *m_contextMenu;
    QAction *m_addToFavouritesContextAction;
    QAction *m_addToQueueContextAction;
    QAction *m_downloadContextAction;
    QLabel *m_titleLabel;
    QLabel *m_descriptionLabel;
    QLabel *m_artistLabel;
    QLabel *m_dateLabel;
    ThumbnailLabel *m_thumbnail;
    QPushButton *m_playButton;
    SeparatorLabel *m_separator1;
    SeparatorLabel *m_separator2;
    QScrollArea *m_scrollArea;
};

#endif // PLAYLISTVIDEOSWINDOW_H
