#include "grouplisttab.h"
#include "grouplistdelegate.h"
#include "tracklistwindow.h"
#include "listview.h"
#include "../base/notifications.h"
#include "../base/windowstack.h"
#include "../base/grouplistmodel.h"
#include <QLabel>
#include <QGridLayout>
#include <QMaemo5Style>

GroupListTab::GroupListTab(QWidget *parent) :
    AbstractTab(parent),
    m_listView(new ListView(this)),
    m_model(new GroupListModel(this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No groups found")), this)),
    m_grid(new QGridLayout(this))
{
    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new GroupListDelegate(m_listView));
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMoreGroups()));

    this->onOrientationChanged();
}

void GroupListTab::setGroupFeed(const QUrl &feed) {
    m_model->getGroups(feed);
}

void GroupListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void GroupListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void GroupListTab::onLoadingChanged(bool loading) {
    Notifications::toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void GroupListTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void GroupListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showGroup(m_model->get(index.row()));
    }
}

void GroupListTab::showGroup(QSharedPointer<GroupItem> group) {
    TrackListWindow *window = new TrackListWindow(WindowStack::instance()->currentWindow());
    window->setWindowTitle(group.data()->title());
    window->getGroupTracks(group);
    window->show();
}
