#ifndef CHANNELWINDOW_H
#define CHANNELWINDOW_H

#include "stackedwindow.h"

class ProfileTab;
class TrackListTab;
class PlaylistListTab;
class GroupListTab;
class UserListTab;
class QStackedWidget;
class QActionGroup;
class QMenu;

class ChannelWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit ChannelWindow(const QString &userId, QWidget *parent);

private:
    void clearMenuActions();

private slots:
    void showProfile();
    void showUploads();
    void showFavourites();
    void showPlaylists();
    void showGroups();
    void showFollowings();

private:
    QString m_userId;
    QMenu *m_menu;
    QActionGroup *m_actionGroup;
    QAction *m_profileAction;
    QAction *m_uploadsAction;
    QAction *m_favouritesAction;
    QAction *m_playlistsAction;
    QAction *m_groupsAction;
    QAction *m_followingsAction;
    QStackedWidget *m_tabWidget;
    ProfileTab *m_profileTab;
    TrackListTab *m_uploadsTab;
    TrackListTab *m_favouritesTab;
    PlaylistListTab *m_playlistsTab;
    GroupListTab *m_groupsTab;
    UserListTab *m_followingsTab;
};

#endif // CHANNELWINDOW_H
