#include "archiveplayliststab.h"
#include "listview.h"
#include "filterbox.h"
#include "querydialog.h"
#include "archiveplaylistdelegate.h"
#include "playlisttrackswindow.h"
#include "../base/playlistlistmodel.h"
#include "../base/archiveplaylistmodel.h"
#include "../base/windowstack.h"
#include <QLabel>
#include <QMenu>
#include <QAction>
#include <QVBoxLayout>
#include <QMaemo5Style>

ArchivePlaylistsTab::ArchivePlaylistsTab(QWidget *parent) :
    AbstractTab(parent),
    m_model(new ArchivePlaylistModel(this)),
    m_view(new ListView(this)),
    m_filterBox(new FilterBox(this)),
    m_contextMenu(new QMenu(this)),
    m_contextDeleteAction(m_contextMenu->addAction(tr("Delete"), this, SLOT(showConfirmDeleteDialog()))),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No playlists found")), this)),
    m_vbox(new QVBoxLayout(this))
{
    m_vbox->setContentsMargins(0, 0, 0, 0);
    m_vbox->addWidget(m_view);
    m_vbox->addWidget(m_filterBox);
    m_filterBox->hide();
    m_noResultsLabel->hide();
    m_view->setModel(m_model);
    m_view->setItemDelegate(new ArchivePlaylistDelegate(m_view));

    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_view, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_view, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));
    this->connect(m_filterBox, SIGNAL(cleared()), m_filterBox, SLOT(hide()));
    this->connect(m_filterBox, SIGNAL(filterTextChanged(QString)), m_model, SLOT(setQuery(QString)));

    m_model->getPlaylists();
    this->onOrientationChanged();
}

void ArchivePlaylistsTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void ArchivePlaylistsTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void ArchivePlaylistsTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible(!count);
}

void ArchivePlaylistsTab::onItemClicked(const QModelIndex &index) {
    PlaylistTracksWindow *window = new PlaylistTracksWindow(m_model->get(index.row()), WindowStack::instance()->currentWindow());
    window->show();
}

void ArchivePlaylistsTab::showContextMenu(const QPoint &pos) {
    m_contextMenu->popup(pos, m_contextDeleteAction);
}

void ArchivePlaylistsTab::showConfirmDeleteDialog() {
    QueryDialog *dialog = new QueryDialog(QString("%1 '%2' %3?").arg(tr("Do you wish to delete")).arg(m_model->data(m_view->currentIndex(), PlaylistListModel::TitleRole).toString()).arg(tr("and its tracks")), this);
    dialog->setWindowTitle(tr("Delete?"));
    dialog->open();
    this->connect(dialog, SIGNAL(accepted()), this, SLOT(deletePlaylist()));
}

void ArchivePlaylistsTab::deletePlaylist() {

}

void ArchivePlaylistsTab::keyPressEvent(QKeyEvent *event) {
    if ((m_filterBox->isHidden()) && (event->key() >= Qt::Key_0) && (event->key() <= Qt::Key_Z)) {
        this->showFilterBox();
        m_filterBox->setFilterText(event->text());
    }
}

void ArchivePlaylistsTab::showFilterBox() {
    m_filterBox->show();
    m_filterBox->setFocus(Qt::OtherFocusReason);
}
