#ifndef ACCOUNTSDIALOG_H
#define ACCOUNTDIALOG_H

#include "abstractdialog.h"

class QLabel;
class QPushButton;
class QLineEdit;
class SoundCloudWebView;

class AccountsDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit AccountsDialog(QWidget *parent = 0);

private slots:
    void onSoundCloudUsernameChanged(const QString &text);
    void onSoundCloudPasswordChanged(const QString &text);
    void onLastfmUsernameChanged(const QString &text);
    void onLastfmPasswordChanged(const QString &text);
    void signInToSoundCloud();
    void showSoundCloudWebView();
    void signInToLastfm();
    void onSoundCloudSignInChanged(bool signedIn);
    void onLastfmSignInChanged(bool signedIn);
    
private:
    QLabel *m_soundcloudLabel;
    QLabel *m_lastfmLabel;
    QLineEdit *m_soundcloudUserEdit;
    QLineEdit *m_soundcloudPassEdit;
    QLineEdit *m_lastfmUserEdit;
    QLineEdit *m_lastfmPassEdit;
    QPushButton *m_soundcloudButton;
    QPushButton *m_soundcloudWebButton;
    QPushButton *m_lastfmButton;
    SoundCloudWebView *m_soundcloudWebView;
};

#endif // ACCOUNTDIALOG_H
