#include "accountsdialog.h"
#include "separatorlabel.h"
#include "soundcloudwebview.h"
#include "../base/soundcloud.h"
#include "../base/lastfm.h"
#include "../base/database.h"
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QVBoxLayout>
#include <QScrollArea>

AccountsDialog::AccountsDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_soundcloudLabel(new QLabel(SoundCloud::instance()->userSignedIn() ? tr("You are connected to your SoundCloud account") : tr("Connect to your SoundCloud account"), this)),
    m_lastfmLabel(new QLabel(Lastfm::instance()->userSignedIn() ? tr("You are signed in to your Last.fm account") : tr("Sign in to your Last.fm account"))),
    m_soundcloudUserEdit(SoundCloud::instance()->userSignedIn() ? 0 : new QLineEdit(this)),
    m_soundcloudPassEdit(SoundCloud::instance()->userSignedIn() ? 0 : new QLineEdit(this)),
    m_lastfmUserEdit(Lastfm::instance()->userSignedIn() ? 0 : new QLineEdit(this)),
    m_lastfmPassEdit(Lastfm::instance()->userSignedIn() ? 0 : new QLineEdit(this)),
    m_soundcloudButton(new QPushButton(SoundCloud::instance()->userSignedIn() ? tr("Disconnect") : tr("Connect"), this)),
    m_soundcloudWebButton(SoundCloud::instance()->userSignedIn() ? 0 : new QPushButton(QIcon(":/images/facebook.png"), tr("Connect via facebook"), this)),
    m_lastfmButton(new QPushButton(Lastfm::instance()->userSignedIn() ? tr("Sign out") : tr("Sign in"), this)),
    m_soundcloudWebView(0)
{
    this->setWindowTitle(tr("Accounts"));

    m_soundcloudLabel->setAlignment(Qt::AlignHCenter);
    m_lastfmLabel->setAlignment(Qt::AlignHCenter);

    if (!SoundCloud::instance()->userSignedIn()) {
        m_soundcloudUserEdit->setFocusPolicy(Qt::ClickFocus);
        m_soundcloudUserEdit->setPlaceholderText(tr("Username"));
        m_soundcloudPassEdit->setFocusPolicy(Qt::ClickFocus);
        m_soundcloudPassEdit->setPlaceholderText(tr("Password"));
        m_soundcloudPassEdit->setEchoMode(QLineEdit::Password);
        m_soundcloudButton->setEnabled(false);

        this->connect(m_soundcloudUserEdit, SIGNAL(textEdited(QString)), this, SLOT(onSoundCloudUsernameChanged(QString)));
        this->connect(m_soundcloudPassEdit, SIGNAL(textEdited(QString)), this, SLOT(onSoundCloudPasswordChanged(QString)));
        this->connect(m_soundcloudButton, SIGNAL(clicked()), this, SLOT(signInToSoundCloud()));
        this->connect(m_soundcloudWebButton, SIGNAL(clicked()), this, SLOT(showSoundCloudWebView()));
    }
    else {
        this->connect(m_soundcloudButton, SIGNAL(clicked()), Database::instance(), SLOT(deleteSoundCloudAccount()));
    }

    if (!Lastfm::instance()->userSignedIn()) {
        m_lastfmUserEdit->setFocusPolicy(Qt::ClickFocus);
        m_lastfmUserEdit->setPlaceholderText(tr("Username"));
        m_lastfmPassEdit->setFocusPolicy(Qt::ClickFocus);
        m_lastfmPassEdit->setPlaceholderText(tr("Password"));
        m_lastfmPassEdit->setEchoMode(QLineEdit::Password);
        m_lastfmButton->setEnabled(false);

        this->connect(m_lastfmUserEdit, SIGNAL(textEdited(QString)), this, SLOT(onLastfmUsernameChanged(QString)));
        this->connect(m_lastfmPassEdit, SIGNAL(textEdited(QString)), this, SLOT(onLastfmPasswordChanged(QString)));
        this->connect(m_lastfmButton, SIGNAL(clicked()), this, SLOT(signInToLastfm()));
    }
    else {
        this->connect(m_lastfmButton, SIGNAL(clicked()), Database::instance(), SLOT(deleteLastfmAccount()));
    }

    QVBoxLayout *layout = new QVBoxLayout(this);
    QScrollArea *scrollArea = new QScrollArea(this);
    QWidget *scrollWidget = new QWidget(scrollArea);
    QVBoxLayout *vbox = new QVBoxLayout(scrollWidget);

    vbox->addWidget(new SeparatorLabel(tr("SoundCloud"), this));
    vbox->addWidget(m_soundcloudLabel);

    if (!SoundCloud::instance()->userSignedIn()) {
        vbox->addWidget(m_soundcloudUserEdit);
        vbox->addWidget(m_soundcloudPassEdit);
    }

    vbox->addWidget(m_soundcloudButton);

    if (!SoundCloud::instance()->userSignedIn()) {
        vbox->addWidget(m_soundcloudWebButton);
    }

    vbox->addWidget(new SeparatorLabel(tr("Last.fm"), this));
    vbox->addWidget(m_lastfmLabel);

    if (!Lastfm::instance()->userSignedIn()) {
        vbox->addWidget(m_lastfmUserEdit);
        vbox->addWidget(m_lastfmPassEdit);
    }

    vbox->addWidget(m_lastfmButton);

    scrollArea->setWidget(scrollWidget);
    scrollArea->setWidgetResizable(true);
    scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    layout->addWidget(scrollArea);

    this->connect(SoundCloud::instance(), SIGNAL(userSignedInChanged(bool)), this, SLOT(onSoundCloudSignInChanged(bool)));
    this->connect(Lastfm::instance(), SIGNAL(userSignedInChanged(bool)), this, SLOT(onLastfmSignInChanged(bool)));
}

void AccountsDialog::onSoundCloudUsernameChanged(const QString &text) {
    m_soundcloudButton->setEnabled((!text.isEmpty()) && (!m_soundcloudPassEdit->text().isEmpty()));
}

void AccountsDialog::onSoundCloudPasswordChanged(const QString &text) {
    m_soundcloudButton->setEnabled((!text.isEmpty()) && (!m_soundcloudUserEdit->text().isEmpty()));
}

void AccountsDialog::onLastfmUsernameChanged(const QString &text) {
    m_lastfmButton->setEnabled((!text.isEmpty()) && (!m_lastfmPassEdit->text().isEmpty()));
}

void AccountsDialog::onLastfmPasswordChanged(const QString &text) {
    m_lastfmButton->setEnabled((!text.isEmpty()) && (!m_lastfmUserEdit->text().isEmpty()));
}

void AccountsDialog::onSoundCloudSignInChanged(bool signedIn) {
    Q_UNUSED(signedIn)

    this->accept();
}

void AccountsDialog::onLastfmSignInChanged(bool signedIn) {
    Q_UNUSED(signedIn)

    this->accept();
}

void AccountsDialog::signInToSoundCloud() {
    SoundCloud::instance()->signIn(m_soundcloudUserEdit->text(), m_soundcloudPassEdit->text());
    m_soundcloudUserEdit->clear();
    m_soundcloudPassEdit->clear();
}

void AccountsDialog::showSoundCloudWebView() {
    if (!m_soundcloudWebView) {
        m_soundcloudWebView = new SoundCloudWebView(this);
    }

    m_soundcloudWebView->open();
}

void AccountsDialog::signInToLastfm() {
    Lastfm::instance()->signIn(m_lastfmUserEdit->text(), m_lastfmPassEdit->text());
    m_lastfmUserEdit->clear();
    m_lastfmPassEdit->clear();
}
