#ifndef TransferListModel_H
#define TransferListModel_H

#include "transferitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class TransferListModel : public QAbstractListModel
{
    Q_OBJECT

    Q_ENUMS(TransferListModel::Roles)

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool itemsSelected
               READ itemsSelected
               NOTIFY itemsSelectedChanged)

public:
    enum Roles {
        TitleRole = Qt::UserRole + 1,
        DownloadPathRole,
        StatusRole,
        StatusTextRole,
        StatusInfoRole,
        ProgressRole,
        SizeRole,
        CurrentIndexRole,
        TotalFilesRole,
        PriorityRole,
        PriorityTextRole,
        ServiceRole,
        TransferTypeRole,
        SelectedRole
    };

public:
    explicit TransferListModel(QObject *parent = 0);
    ~TransferListModel();
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    bool setData(const QModelIndex &index, const QVariant &value, int role);
    Q_INVOKABLE bool setData(int row, const QVariant &value, const QByteArray &role);
    QSharedPointer<TransferItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE TransferItem* getFromQML(int row) const;
#endif
    inline bool itemsSelected() const { return !m_selectedRows.isEmpty(); }

public slots:
    void toggleSelected(int row);
    void selectAll();
    void selectNone();
    void pauseSelectedTransfers();
    void resumeSelectedTransfers();
    void cancelSelectedTransfers();

private:
    void clearTransfers();
    void selectRow(int row);
    void unselectRow(int row);
    int indexOf(TransferItem *transfer) const;

private slots:
    void onTransferDataChanged();
    void onTransferRemoved(int row);

signals:
    void countChanged(int count);
    void itemsSelectedChanged(bool selected);

private:
    QList<int> m_selectedRows;
};

#endif // TransferListModel_H
