#include "tracklauncher.h"
#include "settings.h"
#include <QProcess>
#include <QTemporaryFile>
#include <QDesktopServices>
#include <QDir>
#include <QTimer>
#ifndef SYMBIAN_OS
#include <QDBusConnection>
#include <QDBusInterface>
#endif

TrackLauncher::TrackLauncher(QObject *parent) :
    QObject(parent)
{
}

void TrackLauncher::launchTrack(const QUrl &url) {
#ifdef SYMBIAN_OS
    QTemporaryFile *temp = new QTemporaryFile;
    temp->setFileName(QDir::tempPath() + "/musikloud.ram");

    if ((temp->open()) && (temp->write(QByteArray::fromPercentEncoding(url.toString().toUtf8())) > 0)) {
        QDesktopServices::openUrl(QUrl::fromLocalFile(temp->fileName()));
    }

    temp->close();
    QTimer::singleShot(5000, temp, SLOT(deleteLater()));
#else
    if (Settings::instance()->mediaPlayer() == "other") {
        QStringList args = Settings::instance()->mediaPlayerCommand().split(' ', QString::SkipEmptyParts);
        QProcess *player = new QProcess;
        QObject::connect(player, SIGNAL(finished(int, QProcess::ExitStatus)), player, SLOT(deleteLater()));
        player->start(args.takeFirst(), args << url.toString());
    }
    else {
        QDBusConnection bus = QDBusConnection::sessionBus();
        QDBusInterface dbus_iface("com.nokia." + Settings::instance()->mediaPlayer(), "/com/nokia/" + Settings::instance()->mediaPlayer(), "com.nokia." + Settings::instance()->mediaPlayer(), bus);
        dbus_iface.call("mime_open", url.toString());
    }
#endif
}

void TrackLauncher::launchTracks(QList<QUrl> &urls) {
    QTemporaryFile *temp = new QTemporaryFile;
    temp->setFileName(QDir::tempPath() + "/musikloud.m3u");

    if (temp->open()) {
        while (!urls.isEmpty()) {
            temp->write(urls.takeFirst().toString().toUtf8() + '\n');
        }
#ifdef SYMBIAN_OS
        QDesktopServices::openUrl(QUrl::fromLocalFile(temp->fileName()));
#else
        if (Settings::instance()->mediaPlayer() == "other") {
            QStringList args = Settings::instance()->mediaPlayerCommand().split(' ', QString::SkipEmptyParts);
            QProcess *player = new QProcess;
            QObject::connect(player, SIGNAL(finished(int, QProcess::ExitStatus)), player, SLOT(deleteLater()));
            player->start(args.takeFirst(), args << temp->fileName());
        }
        else {
            QDBusConnection bus = QDBusConnection::sessionBus();
            QDBusInterface dbus_iface("com.nokia." + Settings::instance()->mediaPlayer(), "/com/nokia/" + Settings::instance()->mediaPlayer(), "com.nokia." + Settings::instance()->mediaPlayer(), bus);
            dbus_iface.call("mime_open", temp->fileName());
        }
#endif
    }

    temp->close();
    QTimer::singleShot(5000, temp, SLOT(deleteLater()));
}
