#ifndef MEDIAPLAYER_H
#define MEDIAPLAYER_H

#include "trackitem.h"
#include <QMediaPlayer>
#include <QSharedPointer>

class MediaPlayer : public QMediaPlayer
{
    Q_OBJECT

    Q_ENUMS(PlaybackMode)

    Q_PROPERTY(PlaybackMode playbackMode
               READ playbackMode
               WRITE setPlaybackMode
               NOTIFY playbackModeChanged)
    Q_PROPERTY(int currentIndex
               READ currentIndex
               WRITE setCurrentIndex
               NOTIFY currentIndexChanged)
#ifdef QML_USER_INTERFACE
    Q_PROPERTY(TrackItem* currentTrack
               READ currentTrack
               NOTIFY currentTrackChanged)
#else
    Q_PROPERTY(QSharedPointer<TrackItem> currentTrack
               READ currentTrack
               NOTIFY currentTrackChanged)
#endif

public:
    enum PlaybackMode {
        Sequential = 0,
        RepeatAll,
        RepeatOne
    };

public:
    explicit MediaPlayer(QObject *parent = 0);
    ~MediaPlayer();
#ifdef QML_USER_INTERFACE
    inline TrackItem* currentTrack() const { return m_track.data(); }
#else
    inline QSharedPointer<TrackItem> currentTrack() const { return m_track; }
#endif
    inline int currentIndex() const { return m_index; }
    PlaybackMode playbackMode() const { return m_playbackMode; }

    static MediaPlayer* instance();
        
public slots:
#ifdef QML_USER_INTERFACE
    void playTrack(TrackItem *track);
    void playTracks(QList<TrackItem*> tracks);
#else
    void playTrack(QSharedPointer<TrackItem> track);
    void playTracks(QList< QSharedPointer<TrackItem> > tracks);
#endif
    void removeTrack(int row);
    void clearTracks();
    void setPlaybackMode(PlaybackMode mode);
    void togglePlaybackMode();
    void togglePlayPause();
    void next();
    void previous();
    void setCurrentIndex(int index);

private:
    void setCurrentTrack(QSharedPointer<TrackItem> track);
    void onTrackPlayed(QSharedPointer<TrackItem> track);

private slots:
    void onMediaStatusChanged(QMediaPlayer::MediaStatus status);
    void onError(QMediaPlayer::Error error);
    void onMediaPlayerChanged(const QString &mediaPlayer);
    void onCountChanged(int count);

signals:
#ifdef QML_USER_INTERFACE
    void currentTrackChanged(TrackItem *track);
#else
    void currentTrackChanged(QSharedPointer<TrackItem> track);
#endif
    void currentIndexChanged(int index);
    void playbackModeChanged(PlaybackMode mode);

private:
    QSharedPointer<TrackItem> m_track;
    int m_index;
    PlaybackMode m_playbackMode;
};

#endif // MEDIAPLAYER_H
