#ifndef CONNECTIONLISTMODEL_H
#define CONNECTIONLISTMODEL_H

#include <QAbstractListModel>

typedef struct {
    QString id;
    QString displayName;
    QString service;
    QString iconSource;
} Connection;

class ConnectionListModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        DisplayNameRole,
        ServiceRole,
        IconSourceRole,
        SelectedRole
    };

public:
    explicit ConnectionListModel(QObject *parent = 0);
    ~ConnectionListModel();
    inline bool loading() const { return m_loading; }
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    Q_INVOKABLE QList<int> selectedRows() const { return m_selectedRows; }
    QStringList connections() const;
    QStringList connectionNames() const;

public slots:
    void clear();
    void reset();
    void getConnections();
    void toggleSelected(int row);

private:
    inline void setLoading(bool loading) { m_loading = loading; emit loadingChanged(loading); }
    inline bool error() const { return m_error; }
    inline void setError(bool error) { m_error = error; }
    void appendConnection(Connection connection);

private slots:
    void addConnections();
    
signals:
    void countChanged(int count);
    void loadingChanged(bool loading);
    
private:
    QList<Connection> m_list;
    bool m_loading;
    bool m_error;
    QList<int> m_selectedRows;
};

#endif // CONNECTIONLISTMODEL_H
