#include <QSettings>
#include <QCloseEvent>

#include "mainwindow.h"
#include "ui_mainwindow.h"

#include "settingsdialog.h"
#include "channelsform.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    //ui->pushButton->setText(mSomaLib->hello());

    channelsForm = new ChannelsForm();

    readSettings();

    setCentralWidget(channelsForm);

    channelsForm->show();
    channelsForm->fillChannelList();

    setActions();
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type())
    {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::closeEvent(QCloseEvent *event)
{
    writeSettings();
    event->accept();
}

void MainWindow::setActions()
{
    connect(ui->actionExit, SIGNAL(triggered()), this, SLOT(close()));
    connect(ui->actionSettings, SIGNAL(triggered()), this, SLOT(settingsAction()));
}

void MainWindow::mySlot()
{
    ui->pushButton->setText(tr("Thanks for clicking me! :)"));
}

void MainWindow::settingsAction()
{
    SettingsDialog dialog(this);
    dialog.setChannelsFeedUrl(channelsForm->getChannelsFeedUrl());
    dialog.setShowRecentlyPlayedSongs(channelsForm->isShowRecentlyPlayedSongs());

    if (dialog.exec() == QDialog::Accepted)
    {
        channelsForm->setChannelsFeedUrl(channelsForm->getChannelsFeedUrl());
        channelsForm->setShowRecentlyPlayedSongs(dialog.isShowRecentlyPlayedSongs());
        writeSettings();
    }
}

void MainWindow::readSettings()
{
    QSettings settings("mSoma", "mSoma");
    channelsForm->readSettings(settings);
}

void MainWindow::writeSettings()
{
    QSettings settings("mSoma", "mSoma");
    channelsForm->writeSettings(settings);
}
