#ifndef CHANNELSFORM_H
#define CHANNELSFORM_H

#include <QWidget>
#include <QHttp>
#include <QByteArray>
#include <QSettings>

// qt-mobility
#include <QMediaPlayer>

#include "msomachannels.h"

namespace Ui {
    class ChannelsForm;
}

class QSignalMapper;
class QNetworkAccessManager;
class QNetworkReply;
class QMediaPlaylist;
class QTimer;

class ChannelsForm : public QWidget
{
    Q_OBJECT

public:
    explicit ChannelsForm(QWidget *parent = 0);
    ~ChannelsForm();

    void readSettings(QSettings &settings);
    void writeSettings(QSettings &settings);

    void fillChannelList();

    void setChannelsFeedUrl(const QString &url) { channelsFeedUrl = url; }
    QString getChannelsFeedUrl() const { return channelsFeedUrl; }

    void setShowRecentlyPlayedSongs(bool b) { showRecentlyPlayedSongs = b; }
    bool isShowRecentlyPlayedSongs() const { return showRecentlyPlayedSongs; }

protected:
    void startUpdating();
    void endUpdating();

    /**
      * Enables the play buttons corresponding to playlists
      * in the specified channel
      */
    void enablePlayButtons(const MSomaChannel &channel);
    void disablePlayButtons();
    void enableStopButton();
    void disableStopButton();

private slots:
    void updateChannels();

    void finished(int id, bool error);
    void readData(const QHttpResponseHeader &);

    void setStatus(const QString &s = "");
    void setErrorStatus(const QString &s);
    void setErrorStatus(const QString &s, int error);
    void updateStatus(const QString &s);

    void updateChannelInfo(int position);

    void abortFetching();

    void playPlaylist(const QString &url);

    void finishReadingPlaylist(QNetworkReply *reply);

    void stopPlaying();

    void pausePlaying();

    void setState(QMediaPlayer::State state);
    void setMediaStatus(QMediaPlayer::MediaStatus state);

    void finishReadingSongs(QNetworkReply *reply);

    void checkByteSongs();
    void finishReadingByteSongs(QNetworkReply *reply);

    void readSongs();

    void startSongsList();
    void stopSongsList();

private:
    Ui::ChannelsForm *ui;

    /// for reading the channels feed
    QHttp http;

    /// for reading the channels feed
    int connectionId;

    /// for reading the channels feed
    int httpResponseCode;

    /// for reading the channels feed
    QString httpResponsePhrase;

    /// the channel feed data
    QByteArray data;

    /// the current channels
    MSomaChannels channels;

    /// the current chosen channel
    MSomaChannel channel;

    /// the current chosen playlist
    MSomaPlaylist playlist;

    /// the url of the channels feed
    QString channelsFeedUrl;

    /// whether to show the list of recently played songs
    bool showRecentlyPlayedSongs;

    /// for mapping playlist buttons
    QSignalMapper *signalMapper;

    /// for reading the stream information of a playlist
    QNetworkAccessManager *playlistNetworkReader;

    /// for reading the songs information of a channel
    QNetworkAccessManager *songsNetworkReader;

    /// for reading the byte saying whether we need to reload songs list
    QNetworkAccessManager *songsByteNetworkReader;

    /// the actual player of remote stream
    QMediaPlayer *player;

    /// the playlist for the player
    QMediaPlaylist *mediaplaylist;

    /// the current state of the player
    QMediaPlayer::State playerState;

    /// to check whether the songs list needs to be reloaded
    QString nowPlayingUrlByte;

    /// for periodically reading the songs byte
    QTimer *nowPlayingUrlTimer;
};

#endif // CHANNELSFORM_H
