#include <QDebug>
#include <QDateTime>

#include "songsreader.h"

SongsReader::SongsReader()
{
}

SongsReader::SongsReader(const QByteArray &d) : data(d)
{
    xml.addData(data);
}

void SongsReader::addData(const QByteArray &data_)
{
    data.append(data_);
    xml.addData(data);
}

MSomaSongs SongsReader::readSongs()
{
    MSomaSongs songs;
    MSomaSong song;
    QString currentTag;
    QString currentElement; // the current element of a channel
    while (!xml.atEnd()) {
        xml.readNext();
        if (xml.isStartElement()) {
            if (xml.name() == "song") {
                song = MSomaSong();
            } else {
                currentElement = xml.name().toString();
            }
        } else if (xml.isEndElement()) {
            if (xml.name() == "song") {
                songs << song;
            }
        } else if (xml.isCharacters() && !xml.isWhitespace()) {
            if (currentElement == "date") {
                song.values[currentElement] = QDateTime::fromTime_t((xml.text().toString()).toUInt()).toString();
            } else {
                song.values[currentElement] = xml.text().toString();
            }
        }
        //qDebug() << "name: " << xml.name();
        //qDebug() << "value: " << xml.text().toString();
    }
    if (xml.error() && xml.error() != QXmlStreamReader::PrematureEndOfDocumentError) {
        qWarning() << "XML ERROR:" << xml.lineNumber() << ": " << xml.errorString();
    }

    return songs;
}
