#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>
#include <gtk/gtk.h>

#define Uses_SCIM_CONFIG_BASE
#define Uses_SCIM_CONFIG_PATH
#define Uses_SCIM_MODULE
#define Uses_SCIM_IMENGINE_MODULE
#define Uses_STL_MAP
#include "hildon/hildon.h"
#include "scim_private.h"
#include "scim.h"
#include "scim_setup_module.h"

using namespace scim;

static ConfigPointer config_pointer;
static std::vector <String> uuids;
static std::vector <HildonCheckButton*> factory_buttons;
static GtkWidget* follow_cursor_button;
static std::vector<String>  setup_list;

#define SCIM_CONFIG_PANEL_GTK_DEFAULT_STICKED           "/Panel/Gtk/DefaultSticked"


static void
get_factory_list (const ConfigPointer &config)
{
    std::vector<String>    module_list;
    IMEngineFactoryPointer factory;
    IMEngineModule         module;
    std::vector <String> disabled;
    disabled = scim_global_config_read (String (SCIM_GLOBAL_CONFIG_DISABLED_IMENGINE_FACTORIES), disabled);
    std::sort (disabled.begin (), disabled.end ());
    
    scim_get_imengine_module_list (module_list);

    uuids.clear ();
    factory_buttons.clear ();
    for (size_t i = 0; i < module_list.size (); ++ i) {

        module.load (module_list [i], config);

        if (module.valid ()) {
            for (size_t j = 0; j < module.number_of_factories (); ++j) {
                try {
                    factory = module.create_factory (j);
                } catch (...) {
                    factory.reset ();
                }

                if (!factory.null ()) {
                    if (std::find (uuids.begin (), uuids.end (), factory->get_uuid ()) == uuids.end ()) {
                        String uuid=factory->get_uuid ();
                        uuids.push_back (uuid);
                        //names.push_back (utf8_wcstombs (factory->get_name ()));
                        GtkWidget *button = hildon_check_button_new(HILDON_SIZE_FINGER_HEIGHT);
			String  mbs = String(_("Enable "));
			mbs.append(utf8_wcstombs (factory->get_name ()));
                        //gchar *name= g_strconcat(N_("Enable "),mbs.c_str());
                        gtk_button_set_label (GTK_BUTTON(button),mbs.c_str());
                        //g_free(name);
                        if (uuid.length() && std::binary_search (disabled.begin (), disabled.end (), uuid))
							hildon_check_button_set_active((HildonCheckButton*)button,false);
                        else
                            hildon_check_button_set_active((HildonCheckButton*)button,true);
                        factory_buttons.push_back((HildonCheckButton*)button);
                    }
                    factory.reset ();
                }
            }
            module.unload ();
        }
    }
}

void setup_button_clicked_callback(GtkButton *button, gpointer user_data)
{
  uint32 i=(uint32)GPOINTER_TO_INT (user_data);
  SetupModule *setup_module = new SetupModule (setup_list [i]);
  setup_module->load_config (config_pointer);
  setup_module->create_ui ();
  delete setup_module;
}

void get_setup_modules(GtkBox *box)
{
    scim_get_setup_module_list (setup_list);
    SetupModule *setup_module;
    for (size_t i = 0; i < setup_list.size (); ++ i) {
	setup_module = new SetupModule (setup_list [i]);
	if (setup_module && setup_module->valid ()) {
	  String  module_label    = setup_module->get_name ();
	  if (module_label.length ())
	  {
	    GtkWidget *button = hildon_gtk_button_new(HILDON_SIZE_FINGER_HEIGHT);
	    gtk_button_set_label (GTK_BUTTON(button), module_label.c_str());
	    gtk_button_set_alignment (GTK_BUTTON(button), 0, 0.5);
	    g_signal_connect ((gpointer) button, "clicked",
			      G_CALLBACK (setup_button_clicked_callback),
			      GINT_TO_POINTER (i));
	    gtk_box_pack_start(box,button,FALSE,FALSE,0);
	  }
	}
	if (setup_module) {
	  delete setup_module;
	}
    }
}

//Module Interface
extern "C" {

static const gchar * authors[] = {"Evan JIANG <firstfan@gmail.com",
                          "Alsor Zhou <alsor.zhou@gmail.com>"};
static const gchar * artists[] = {"larens <larens@qq.com>"};
/*
 * TODO: Maintain the settings configuration
 */
osso_return_t
execute(osso_context_t *osso ,
        gpointer data ,
        gboolean user_activated)
{
//        if (uuid == "8034d025-bdfc-4a10-86a4-82b9461b32b0") {

    //TODO: get the user/sys config from socket, refer to ~/.scim
    String config;
    config = scim_global_config_read (SCIM_GLOBAL_CONFIG_DEFAULT_CONFIG_MODULE, String ("simple"));

    ConfigModule config_module (config);


    if (config_module.valid ()) {
        config_pointer = config_module.create_config ();
    }

    if (config_pointer.null ()) {
        config_pointer = new DummyConfig ();
    }
    

    GtkWidget *dialog;
    GtkWidget *panarea;
    GtkWidget *box;
    gint response;
    dialog = gtk_dialog_new_with_buttons(
		_("MSCIM Input Method"),
		GTK_WINDOW(data),
		(GtkDialogFlags)(GTK_DIALOG_MODAL | GTK_DIALOG_NO_SEPARATOR),
		GTK_STOCK_SAVE,
		GTK_RESPONSE_OK,
		GTK_STOCK_CANCEL,
		GTK_RESPONSE_CANCEL,
		GTK_STOCK_ABOUT,
		1,
		NULL);
    panarea = hildon_pannable_area_new ();
    box = gtk_vbox_new (FALSE, 0);

    hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA (panarea),
                                            box);
    
    g_object_set (G_OBJECT (panarea), "height-request", 350, NULL);
    follow_cursor_button = hildon_check_button_new(HILDON_SIZE_FINGER_HEIGHT);
    gtk_button_set_label (GTK_BUTTON(follow_cursor_button),N_("Input panel follows the cursor"));
    gtk_box_pack_start(GTK_BOX(box),follow_cursor_button,FALSE,FALSE,0);
    gboolean stick_input_panel = config_pointer->read (String (SCIM_CONFIG_PANEL_GTK_DEFAULT_STICKED),FALSE);    
    hildon_check_button_set_active((HildonCheckButton*)follow_cursor_button,stick_input_panel);

    get_factory_list(config_pointer);
    for (size_t i = 0; i < factory_buttons.size (); ++i)
    		gtk_box_pack_start(GTK_BOX(box),GTK_WIDGET(factory_buttons[i]),FALSE,FALSE,0);
    get_setup_modules(GTK_BOX(box));
    
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),panarea,TRUE,TRUE,0);
    gtk_widget_show_all(GTK_DIALOG(dialog)->vbox);
    response = gtk_dialog_run(GTK_DIALOG(dialog));
    if (response == GTK_RESPONSE_OK)
    {
	   //Save changes
       config_pointer->write (String (SCIM_CONFIG_PANEL_GTK_DEFAULT_STICKED),hildon_check_button_get_active((HildonCheckButton*)follow_cursor_button));
       std::vector <String> disabled;
       for (size_t i = 0; i < factory_buttons.size (); ++i)
         if (!hildon_check_button_get_active(factory_buttons[i]))
            disabled.push_back(uuids[i]);
       scim_global_config_write (String (SCIM_GLOBAL_CONFIG_DISABLED_IMENGINE_FACTORIES), disabled);
       GtkWidget *note;
        note = hildon_note_new_information
            (GTK_WINDOW (data),
             _("Not all configuration can be reloaded on the fly. "
               "Don't forget to restart SCIM in order to let all of "
               "the new configuration take effect."));
        gtk_dialog_run (GTK_DIALOG (note));
        gtk_widget_destroy (note);
    }
    if (response == 1)
    {
	GtkAboutDialog * about_dialog = (GtkAboutDialog *)gtk_about_dialog_new();
	gtk_about_dialog_set_name(about_dialog,_("About"));
	gtk_about_dialog_set_program_name(about_dialog,_("MSCIM Input Method"));
	gtk_about_dialog_set_website (about_dialog,
			"http://code.google.com/p/scim-for-maemo/");
	gtk_about_dialog_set_authors(about_dialog, authors);
	gtk_about_dialog_set_artists(about_dialog, artists);
	gtk_about_dialog_set_license(about_dialog, 
			"GNU General Public License v3\n"
			"http://www.gnu.org/licenses/gpl-3.0.html");
	gtk_dialog_run(GTK_DIALOG(about_dialog));
	gtk_widget_destroy(GTK_WIDGET(about_dialog));

    }
    gtk_widget_destroy(GTK_WIDGET(dialog));
    return OSSO_OK;
}

osso_return_t
save_state(osso_context_t *osso ,
        gpointer data)
{
    /* ... save state ... */
    return OSSO_OK;
}
}
