#ifndef UINETWORKSETTINGS_H
#define UINETWORKSETTINGS_H

#include <QDialog>

#include <servicemgr.h>

namespace Ui {
    class UINetworkSettings;
}

/**
  \brief Network settings form.

  This form shows important network settings (proxy online/offline).
  The settings gets from Service Manager (see \a ServiceMgr).

  \sa ServiceMgr
  */
class UINetworkSettings : public QDialog
{
    Q_OBJECT

public:
    /**
      The form constructor.

      \param sm Pointer to Service Manager instance.

      \param parent Pointer to parent widget.
      */
    explicit UINetworkSettings(ServiceMgr *sm, QWidget *parent = 0);

    /**
      The default destructor.
      */
    ~UINetworkSettings();

private:
    Ui::UINetworkSettings *ui;

    ServiceMgr *sm;

private slots:
    /**
     * @brief pass done button (store settings, etc.)
     *
    */
    void on_buttonBox_accepted();
};

#endif // UINETWORKSETTINGS_H
