#ifndef QMESSAGEDELEGATE_H
#define QMESSAGEDELEGATE_H

#include <QStyledItemDelegate>
#include <QApplication>
#include <datatypes/account.h>
#include <servicemgr.h>

class QMessageDelegate : public QStyledItemDelegate
{
    Q_OBJECT
public:
    explicit QMessageDelegate(ServiceMgr *sm, QObject *parent = 0);

    void paint(QPainter *painter, const QStyleOptionViewItem &option,
                         const QModelIndex &index ) const;

    QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const;

private:
    ServiceMgr *sm;

    AccountList mAccountList;
    QSet<QString> mLocalAccountIds;

public slots:
    void updateAccountList(QString id, AccountList list);
};

#endif // QMESSAGEDELEGATE_H
