// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef THEATERCONTROLLER_H
#define THEATERCONTROLLER_H

#include "data/scheduleentrykey.h"
#include "data/cinemakey.h"

#include <QObject>

class TheaterWindow;
class CinemaSchedule;
class TheaterScheduleModel;
class ItemModelSortController;
class ScheduleEntry;
class ActionController;
class QAbstractItemModel;
class QSortFilterProxyModel;

class TheaterController : public QObject
{
    Q_OBJECT
public:
    TheaterController(TheaterWindow *theater_window, CinemaSchedule *cinema_schedule, ActionController *action_controller,
                      ItemModelSortController *sort_controller, QThread *search_worker);

public:
    Q_SLOT void ShowTheater(CinemaKey cinema_key);
    void Cancel();

private:
    void CancelSearch();
    Q_SLOT void ScheduleEntrySelected(ScheduleEntryKey schedule_entry_key);
    Q_SLOT void SearchStarted(int search_task_id);
    Q_SLOT void Reply(int search_task_id, bool intermediate);
    Q_SLOT void Error(int search_task_id);
    Q_SLOT void SearchFinished(int search_task_id, bool success);

    void Sort(bool intermediate, const char *);
    Q_SLOT void SortFinished(QAbstractItemModel *model, int search_task_id, bool intermediate);
    Q_SLOT void SortErrorFinished(QAbstractItemModel *model, int search_task_id, bool intermediate);
    void SetModel(QAbstractItemModel *model);

private:
    TheaterWindow *_theater_window;
    CinemaSchedule *_cinema_schedule;
    ActionController *_action_controller;
    ItemModelSortController *_sort_controller;
    QThread *_search_worker;
    int _current_search_task_id;
    TheaterScheduleModel *_theater_schedule_model;
    QSortFilterProxyModel *_theater_schedule_proxy_model;
    CinemaKey _cinema_key;
};

#endif // THEATERCONTROLLER_H
