// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef CONTEXTDIALOG_H
#define CONTEXTDIALOG_H

#include "data/cinemakey.h"
#include "data/moviekey.h"
#include "data/scheduleentrykey.h"

#include <QDialog>

class CinemaSchedule;

namespace Ui {
    class ContextDialog;
}

class ContextDialog : public QDialog
{
    Q_OBJECT

public:
    explicit ContextDialog(CinemaSchedule *cinema_schedule, QWidget *parent = 0);
    ~ContextDialog();

public:
    Q_SIGNAL void AddToCalendar(ScheduleEntryKey);
    Q_SIGNAL void CallTheaterByPhone(CinemaKey);
    Q_SIGNAL void FindRouteToTheater(CinemaKey);
    Q_SIGNAL void SearchMovieInWeb(MovieKey);
    Q_SIGNAL void SearchTheaterInWeb(CinemaKey);

public:
    Q_SLOT void Show(ScheduleEntryKey schedule_entry_key);

protected:
    void changeEvent(QEvent *e);

private:
    void removeAllWidgets();
    void addWidget(QWidget *);

    Q_SLOT void AddToCalendar();
    Q_SLOT void CallTheaterByPhone();
    Q_SLOT void FindRouteToTheater();
    Q_SLOT void SearchMovieInWeb();
    Q_SLOT void SearchTheaterInWeb();

    Q_SLOT void Rotate();

private:
    Ui::ContextDialog *ui;
    CinemaSchedule *_cinema_schedule;
    ScheduleEntryKey _schedule_entry_key;
    int _next_row;
    int _next_column;
};

#endif // CONTEXTDIALOG_H
