// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef ACTIONCONTROLLER_H
#define ACTIONCONTROLLER_H

#include "data/cinemakey.h"
#include "data/moviekey.h"
#include "data/scheduleentrykey.h"

#include <QObject>

class CinemaSchedule;

class ActionController : public QObject
{
    Q_OBJECT
public:
    explicit ActionController(const CinemaSchedule *cinema_schedule);

public:
    Q_SLOT void AddToCalendar(ScheduleEntryKey);
    Q_SLOT void CallTheaterByPhone(CinemaKey);
    Q_SLOT void FindRouteToTheater(CinemaKey);
    Q_SLOT void SearchTheaterInWeb(CinemaKey);
    Q_SLOT void SearchMovieInWeb(MovieKey);
    Q_SLOT void ContactAuthor();

private:
    QString TrimPhoneNumber(const QString &phone_number);
    void SearchInWeb(const QString &key);
    void ShowError(const QString &);

private:
    const CinemaSchedule *_cinema_schedule;
};

#endif // ACTIONCONTROLLER_H
