// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef MOVIE_H
#define MOVIE_H

#include "data/moviekey.h"

#include <QString>
#include <QTime>

class Movie
{
public:
    Movie();

    MovieKey GetKey() const { return MovieKey(_name); }

    QString GetName() const { return _name; }
    void SetName(const QString &name) { _name = name; }

    QString GetTheatersUrl() const { return _theaters_url; }
    void SetTheatersUrl(const QString &theaters_url) { _theaters_url = theaters_url; }

    QTime GetDuration() const { return _duration; }
    void SetDuration(const QTime &duration) { _duration = duration; }

    QString GetComment() const { return _comment; }
    void SetComment(const QString &age) { _comment = age; }

    double GetRate() const { return _rate; }
    void SetRate(double rate) { _rate = rate; }

private:
    QString _name;
    QString _theaters_url;
    QTime _duration;
    QString _comment;
    double _rate;
};

#endif // MOVIE_H
