#ifndef VIEWLOGIN_H
#define VIEWLOGIN_H

#include <QLineEdit>
#include <QDeclarativeView>

#include "viewphotodetails.h"

class ViewLogin : public QObject
{
    Q_OBJECT

public:
    explicit ViewLogin(QObject *parent = 0);
    ~ViewLogin();

    Q_INVOKABLE void selectPhoto(QString url);
    void show() const;

private slots:
    void login(bool setCredentials = true);
    void channelListReceived(bool success);
    void postStarted();
    void postFinished();

private:
    // Login form widgets
    QLineEdit *m_username;
    QLineEdit *m_password;
    QWidget *m_formWidget;
    QWidget *m_waitWidget;

    // Views
    QWidget *m_loginview;
    QDeclarativeView *m_photolist;
    ViewPhotoDetails *m_details;

};

#endif // VIEWLOGIN_H
