import QtQuick 1.0
import QtMobility.gallery 1.2

Item {
    id: container
    width: 300
    height: 300

    GridView {
        anchors.fill: parent
        cellWidth: 160
        cellHeight: 120

        model: DocumentGalleryModel {
            rootType: DocumentGallery.Image
            properties: [ "url" ]
            autoUpdate: false
            sortProperties: [ "-dateTaken" ]
            filter: GalleryWildcardFilter {
                property: "fileName"
                value: "*.jpg"
            }
        }

        delegate: Item {
            width: 160
            height: 120
            clip: true
            //color: "black"

            Text {
                anchors.centerIn: parent
                text: model.index + 1
                color: "white"
                font.pixelSize: 25
                font.bold: true
                verticalAlignment: Text.AlignVCenter
                horizontalAlignment: Text.AlignHCenter
            }

            Image {
                id: image
                anchors.fill: parent
                source: url
                fillMode: Image.PreserveAspectCrop
                sourceSize.width: 160
                width: 160
                height: 120
                asynchronous: true
                clip: true

                MouseArea {
                    anchors.fill: parent
                    onPressed: veil.opacity = 0.5
                    onReleased: veil.opacity = 0.0
                    onCanceled: veil.opacity = 0.0
                    onEntered: veil.opacity = 0.5
                    onExited: veil.opacity = 0.0
                    onClicked: controller.selectPhoto(model.url);
                }
            }

            Rectangle {
                id: veil
                anchors.fill: image
                color: "white"
                opacity: 0
            }
        }
    }
}
