import QtQuick 1.0

Rectangle {
    id: application
    color: "black"
    width: 640
    height: 360

    PhotoList {
        id: list
        anchors.fill: parent
        onPhotoSelected: {
            details.photoUrl = url;
            application.state = "details";
        }
    }

    PhotoDetails {
        id: details
        anchors.fill: parent
    }

    states: [
        State {
            name: "list"
            PropertyChanges {
                target: details
                opacity: 0
                transX: application.width
            }
        },
        State {
            name: "details"
            PropertyChanges {
                target: list
                opacity: 0
                transX: -application.width
            }
        }
    ]

    transitions: [
        Transition {
            from: "*"
            to: "*"

            SequentialAnimation {
                PropertyAnimation {
                    properties: "transX"
                }
                PropertyAnimation {
                    properties: "opacity"
                }
            }
        }
    ]

    state: "list"
}
