#ifndef NETWORKHANDLER_H
#define NETWORKHANDLER_H

#include <QNetworkAccessManager>
#include <QSharedPointer>
#include <QObject>
#include <QUrl>
#include <QBuffer>

struct Channel {
    QString name;
    QUrl address;
    bool isDefault;
};

typedef QSharedPointer<QList<QSharedPointer<Channel> > > ChannelList;

struct Image {
    QString postId;
    QString imageTitle;
    QString imageSummary;
    QString postTitle;
    QString postContent;
    QSharedPointer<Channel> channel;
    QSharedPointer<QByteArray> imageData;
};

class NetworkHandler : public QObject
{
    Q_OBJECT

public:
    explicit NetworkHandler(QUrl baseUrl, QObject *parent = 0);
    virtual ~NetworkHandler();

    int xmlTemplateSize() const;

signals:
    void channelsReceived(const ChannelList &channels) const;
    void channelListRequestFailed(const QString &reason) const;
    void postImageCompleted(QSharedPointer<Image> image) const;
    void postImageFailed(const QString &reason) const;

public slots:
    void listChannels();
    void postImage(QSharedPointer<Image> image);

private slots:
    void postImageText(QSharedPointer<Image> image);
    void handleChannelListReply();
    void handlePostImageReply();
    void handlePostTextReply();

private:
    void setWSSEHeadersToRequest(QNetworkRequest &request);
    static QString isoDate();

private:
    QNetworkAccessManager m_manager;
    QUrl m_baseUrl;

    // Data bound to an unfinished network request
    QHash<QNetworkReply*, QSharedPointer<Image> > m_images;
    QHash<QNetworkReply*, QSharedPointer<QBuffer> > m_buffers;
    QHash<QNetworkReply*, QSharedPointer<QByteArray> > m_datas;

};

#endif // NETWORKHANDLER_H
