#ifndef CONFIG_H
#define CONFIG_H

#include <QObject>
#include <QSettings>

class Config : public QObject
{
    Q_OBJECT

public:
    explicit Config(QObject *parent = 0);

    QString username() const;
    void setUsername(QString value);

    QString password() const;
    void setPassword(QString value);

    QString defaultChannel() const;
    void setDefaultChannel(QString value);

    int defaultSize() const;
    void setDefaultSize(int value);

private:
    QString encodeString(QString value) const;
    QString decodeString(QString value) const;

private:
    QSettings m_settings;

};

#endif // CONFIG_H
