#!/usr/bin/env python2.5

#
# PyGTKEditor
#
# Copyright (c) 2007 Khertan (Benoit HERVIER)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#        
# Khertan (Benoit HERVIER) khertan@khertan.net

import hildon
import gtk
import osso
import pango
import gobject
from portrait import FremantleRotation
import os
import datetime
import mnotes_notes
import mnotes_preferences
#import dateutil
#import uuid

class Window(hildon.Window):
  def __init__(self,caller=None):
    hildon.Window.__init__ (self)
    #Prefs
    self.prefs = mnotes_preferences.Prefs()
    self.prefs.load()

    self.is_fullscreen = False    

    self._parent = caller
    
    menu = self.create_menu()
    menu.show_all()
    
    self.set_app_menu(menu)
        
    self.create_treeview()
    p1 = hildon.PannableArea()
    hbox = gtk.HBox()
    self.search_entry = hildon.Entry(0)
    self.search_button = hildon.Button(0,0)
    self.search_button.set_label('Search')
    self.search_entry.set_placeholder('Search')
#    hbox.add(self.search_entry)
#    hbox.add(self.search_button)
#    hbox.set_size_request(-1,40)
#    self.search_button.set_size_request(40,-1)
    vbox = gtk.VBox()
    vbox.pack_end(p1,1)
    vbox.pack_end(self.search_entry,0)
#    hbox.set_size_request(-1,40)
#    vbox.set_size_request(-1,400)
#    p1.set_size_request(-1,-1)
    
    p1.add(self.notesTree)
    self.add(vbox)
    self.set_title('mNotes')

    self.show_all()
    self.rotation = FremantleRotation('net.khertan.mnotes',self,mode=FremantleRotation.NEVER)
    if self.prefs.prefs_dict['auto_rotate']==True:
      self.rotation.set_mode(FremantleRotation.AUTOMATIC)
    else:
      self.rotation.set_mode(FremantleRotation.NEVER)          
    self.load_notes()

    self.connect("key-press-event", self.on_key_press)
    self.search_button.connect("clicked", self.search_notes)
    self.search_entry.connect("activate", self.search_notes)
    
  def search_notes(self,widget,*data):
    self.notesStore.clear()
    text = self.search_entry.get_text()
    for dt,title,uid in mnotes_notes.List().get(text):
      self.notesStore.append((uid,self.replace_pango(title)+'\n<small><span foreground="darkgrey">' + dt.strftime('%x %X</span></small>')))

  def replace_pango(self,t):
    return t.replace('<','[').replace('>',']')
    
  def load_notes(self):
    self.notesStore.clear()
    self._parent.noteslist = []
    for dt,title,uid in mnotes_notes.List().get():
      self.notesStore.append((uid,self.replace_pango(title)+'\n<small><span foreground="darkgrey">' + dt.strftime('%x %X</span></small>')))
      self._parent.noteslist.append((title,uid))

  def edit_note(self,widget,treepath,treecolumn):
    uid = self.notesStore.get_value(self.notesStore.get_iter(treepath),0)
    #Open a note only one time
    self._parent.note_window(uid)   

  def on_key_press(self, widget, event, *args):
    if (event.state==gtk.gdk.CONTROL_MASK):
      #New : CTRL-"
      if (event.keyval == gtk.keysyms.n):
        self._parent.note_window(None) 
      #Close : CTRL-W
      elif (event.keyval == gtk.keysyms.w):
        self.destroy() 
      #Show Help
      elif (event.keyval == gtk.keysyms.h):
        self.show_help()

  def show_help(self):
    import mnotes_help
    mnotes_help.Help()
    
  def create_treeview(self):
    #Store = uid , title 
    self.notesStore = gtk.ListStore(gobject.TYPE_STRING,gobject.TYPE_STRING)

    self.notesTree = hildon.GtkTreeView(gtk.HILDON_UI_MODE_NORMAL)
    self.notesTree.set_model(self.notesStore)
    hildon.hildon_gtk_tree_view_set_ui_mode(self.notesTree,0)
    self.notesTree.set_grid_lines(False)
    self.notesTree.set_fixed_height_mode(True)
    self.notesTree.set_hadjustment(gtk.Adjustment(value=0))
    self.notesTree.connect('row_activated',self.edit_note)
    
    descriptiontextrenderer = gtk.CellRendererText()
    descriptiontextrenderer.set_property('wrap-mode' , pango.WRAP_CHAR)
    descriptiontextrenderer.set_property('height' , 80)
    descriptiontextrenderer.set_property('width' , -1)
    column_description = gtk.TreeViewColumn("Description", descriptiontextrenderer, markup=1)
    column_description.set_spacing(0)
    column_description.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
    self.notesTree.append_column(column_description)
      
  def menu_button_clicked(self,button, label):
    if label == 'New':
      self._parent.note_window(None) 
    elif label=='Sync':
      import mnotes_sync
      mnotes_sync.Sync().start()
    elif label=='About':
      self._parent.onAbout(self)
    elif label == 'Help':
      self.show_help()
    elif label == 'Settings':
      prefs = mnotes_preferences.Prefs()
      prefs.load()
      prefs.edit(self)
    else:
      print "Menu Button clicked: %s" % label

  def create_menu(self):
    menu = hildon.AppMenu()
    #New
    self.new_menu_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
    label = 'New'
    self.new_menu_button.set_label(label)
    self.new_menu_button.connect("clicked", self.menu_button_clicked, label)
    menu.append(self.new_menu_button)
    self.about_menu_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
    label = 'About'
    self.about_menu_button.set_label(label)
    self.about_menu_button.connect("clicked", self.menu_button_clicked, label)
    menu.append(self.about_menu_button)
    self.sync_menu_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
    label = 'Sync'
    self.sync_menu_button.set_label(label)
    self.sync_menu_button.connect("clicked", self.menu_button_clicked, label)
    menu.append(self.sync_menu_button)

    self.settings_menu_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
    label = 'Settings'
    self.settings_menu_button.set_label(label)
    self.settings_menu_button.connect("clicked", self.menu_button_clicked, label)
    menu.append(self.settings_menu_button)
    self.help_menu_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO) 
    label = 'Help'                                             
    self.help_menu_button.set_label(label)                   
    self.help_menu_button.connect("clicked", self.menu_button_clicked, label)
    menu.append(self.help_menu_button)                  
                                              
    return menu

  def apply_prefs(self):
    self.prefs.load()
    #rotate
    if self.prefs.prefs_dict['auto_rotate']==True:
      self.rotation.set_mode(FremantleRotation.AUTOMATIC)
    else:
      self.rotation.set_mode(FremantleRotation.NEVER)

