# author: Bartosz 'misiak' Miskiewicz 2011
# email: miskiewicz.bartosz@gmail.com

import bluetooth
import os

# config of port and uuid 
# (uuid search and service records are broken in N900 anyway)
port = 3
uuid = "DBBCEE60-70F7-11E0-A1F0-0800200C9A66"

# repeat endlessly
while True:
    # open socket
    server_sock=bluetooth.BluetoothSocket( bluetooth.RFCOMM )
    server_sock.bind(("",port))
    server_sock.listen(1)
    print "listening on port %d" % port
    # advertise service (cannot be found by other Nokia phones anyway due to bug in bluez)
    bluetooth.advertise_service( server_sock, "mmmRemotePhoneControl", uuid )
    print "Waiting for connections"
    # wait for connection
    client_sock,address = server_sock.accept()
    print "Accepted connection from ",address
    # wait endlessly for input while connected
    while True:
        try:
            # receive commands
            data = client_sock.recv(1024)
            print "received [%s]" % data
            command = str(data)
            type = command[:1]
            command = command[1:]
            # normal keyboard event
            if type == "K":
                # make typing slashes possible
                command = command.replace("\\", "\\\\")
                # and other special chars
                command = command.replace("\"", "\\\"")
                command = command.replace("\`", "\\\`")
                # simulate typing
                os.system("xdotool type --delay 200 \"" + command +"\"")
            # special keyboard event - key combination
            elif type == "S":
                # simulate keypress events
                os.system("xdotool key \"" + command + "\"")
            # mouse event
            elif type == "M":
                # simulate mouse clicks
                startx = int(command[0:4])
                starty = int(command[4:8])
                stopx = int(command[8:12])
                stopy = int(command[12:16])
                os.system("xdotool getactivewindow mousemove --sync " + str(startx) + " " + str(starty))
                os.system("xdotool getactivewindow mousedown 1")
                os.system("xdotool getactivewindow mousemove --sync " + str(stopx) + " " + str(stopy))
                os.system("xdotool getactivewindow mouseup 1")
            else:
                print "unrecognized command type: ",type
        except:
            # client disconnected or something unexpected happened
            print "Disconnected from", address
            break
    # close opened sockets
    client_sock.close()
    server_sock.close()
